#ifndef lint
static char *sccsid = "@(#) 2.4 src/somples.os2/somd/c/event/eventcli.c, somx, som2.0.fix, csd2.0.4 5/5/94 14:06:39 [5/23/94 10:10:28]";
#endif

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include <errno.h>

#include <somd.h>
#include <orb.h>

/* Local includes follow */
#include "cell.h"

int  read_obj_ref(SOMDObject *objref, char *file);

char   dispBuf[512];
string dispp;
string dispStr;

extern ORB                       SOMD_ORBObject;
extern SOMDObjectMgr             SOMD_ObjectMgr;

Environment ev;

int main(int argc, char *argv[])
{
    char                                 answer[10];
    Cell                                 cellObj;
    int                                  rc;
    long                                 init_val = 10;

    SOM_InitEnvironment(&ev);
    SOMD_Init(&ev);

    /* The <object>NewClass invocation is optional and unnecessary
     * in the client program when the class object is created in the
     * SOMInitModule function that is invoked during DLL initialization.
     */
    CellNewClass(0,0);

    rc =  read_obj_ref(&cellObj, "cell.rep");
    if (rc) exit(1);

    printf("Setting initial value of cell to: %ld\n", init_val);
    __set_val(cellObj, &ev, init_val);
    printf("Increment cell value by 1? <return to continue or Q/q to quit>\n");
    gets(answer);

    while (strcmp(answer,"q") != 0 && strcmp(answer, "Q") != 0)
    {
       init_val++;
       __set_val(cellObj, &ev, init_val);
       printf("Increment cell value by 1? <return to continue or Q/q to quit>\n");
       gets(answer);
    }

    _somdReleaseObject(SOMD_ObjectMgr, &ev, cellObj);
    return 0;
}


int  read_obj_ref(SOMDObject *objref, char *file)
{
    FILE *fd;
    char  *objRefStr, *p;
    int rc = 0;

    if ((fd = fopen (file, "r")) == (FILE *) NULL)
    {
	printf ("Unable to find object ref string in %s\n", file);
	rc = -1;
    }
    else
    {
	objRefStr = (char *) SOMMalloc (512);
	p = objRefStr;

	while (! feof (fd))
	{
	    fread (p, sizeof (char), 1, fd);
	    ++p;
	}

	*(--p) = (char) NULL;

	*objref = _somdGetObjectFromId (SOMD_ObjectMgr, &ev, objRefStr);

	if (*objref == NULL)
	{
	    printf ("Unable to get objref from string %s.\n", objRefStr);
	    rc = -1;
	}

	SOMFree (objRefStr);
    }

    fclose (fd);
    return (rc);
}

